/*
 * 功能:生成带操作的界面
 * 编辑时间：2014-03-05
 * 作者    ：Arvin.chen@zkteco.com
 */
(function($) {
$.addMobile = function(t, p) {//t ->table  p ->document
        if (t.grid)
            return false; // return if already exist
        $(t).empty();
        p = $.extend({    //update
            model_actions:[],
            data_actions:[],
            method:'POST',
            dataType:'json',
            page : 1, // 默认当前页
            total : 1, // 总页面数
            rp : 15, // 每页默认的结果数
            params : [],
        }, p);

        $(t).show()
        var g={
            populate:function(){  //获取参数，请求数据
              $('#more').hide();
              $('#loader').show();
              if (!p.newp)
                p.newp = 1;

              if (p.page > p.pages)
                p.page = p.pages;

              var param =[
                 {'name':'rp','value':p.rp},
                 {'name':'page','value':p.newp},
              ];
              if(p.params){
                 for (var pi = 0; pi < p.params.length; pi++){
                    param[param.length] = p.params[pi];
                 }
              }
              $.ajax({
                    type : p.method,
                    url : p.url,
                    data : param,
                    dataType : p.dataType,
                    success : function(data) {
                        g.addData(data);
                    },
                    error : function(data) {
                        $('#loader').hide();
                        try {
                            if (p.onError)
                                p.onError(data);
                        } catch (e) {
                        }
                    }
            });
          },
          addData:function(data){ //生成数据显示页面
            p.total = data.total;
            if (p.total == 0) {
              $('a,div', t).unbind();
              $('#more').empty();
              $('#more').append('<div class="wap-no-data"><p>'+gettext("没有数据")+'</p></div>');
              p.pages = 1;
              p.page = 1;
              $('#more').show();
              $('#loader').hide();
              return false;
            }
            p.pages = Math.ceil(p.total / p.rp);
            p.page = data.page;
            if(p.page==p.pages){
               $('#more').remove();
            }else{
               $('#more').unbind().click(function(){
                p.newp+=1;
                g.populate()
              });
              $('#more').show();
            }
            var tbody = document.createElement('tbody');
            if(p.dataType=='json'){
                $.each(data.rows, function(i, row){
                    var tr=document.createElement('tr')
                    if(row.id)
                       tr.id = 'row' + row.id;
                    var tdVal=[];
                    if(p.colModel){
                      for(var j=0;j<p.colModel.length;j++){
                        var cm = p.colModel[j];
                        var seleceName = cm.name;
                        if (typeof(data.rows[i][seleceName]) == 'undefined') {
                          data.rows[i][seleceName] = ''
                        }
                        $.each(data.rows[i],function(x,y){
                          if(seleceName==x)
                          tdVal.push(y);
                        })
                      }
                    }
                    $('thead tr:first th',t).each(function(){
                        var td=document.createElement('td');
                        var idx = $(this).attr('axis').substr(3);
						if($(this).attr('name')=='operation'){
						   $(tr).append('<td><a data-role="button" data-iconpos="notext" data-icon="grid"></a></td>');
						   if(p.s_url){
                              $(tr).unbind().click(function(){
                                window.location.href=p.s_url+'&K='+row.id;
                             })
                           }
						}else{
							td.innerHTML=tdVal[idx];
							if(this.hide){
							   $(td).css('display','none');
							}
							$(tr).append(td);
							td=null;
						}
                    })
                    $(tbody).append(tr);
                    tr=null;
                })
				$(t).append(tbody);
                $('table#table-reflow tbody')
                    .closest('table#table-reflow') //Call the refresh method
                    .trigger('create'); //Trigger if the new injected markup contain links or buttons that need to be enhanced
//                    .table('refresh');  //refresh
                $('#loader').hide();
            }
          },
        };
		var thead=document.createElement('thead');
        if(p.colModel){  //生成报表头部信息
			var tr=document.createElement('tr');
			$(tr).addClass('ui-bar-d');
            for (i = 0; i < p.colModel.length; i++){
                var cm = p.colModel[i]
				var th=document.createElement('th');
				if(cm.hide){
				    th.hide=true;
		            $(th).css('display','none');
				}
				if(cm.name)
				    $(th).attr('name',cm.name);
				$(th).attr('axis','col'+i);
				th.innerHTML=cm.display;
				$(tr).append(th);
			}
			$(thead).append(tr)
        }
        $(t).append(thead);
        // make grid functions accessible
        t.p = p;
        t.grid = g;


        if(p.url){
            g.populate();
        }
        return t;
    };
    var docloaded = false; //标识html页面是否加载完成
    $(document).ready(function() {
            docloaded = true
        });
    //初始化页面
    $.fn.mobileGrid=function(p){
       return this.each(function(){

           if(!docloaded){
              $(this).hide();
              var t = this;
              $(document).ready(function() {
                 $.addMobile(t, p);
              });
        }else{
           $.addMobile(this,p)
        }
      });
    };
    //页面刷新
    $.fn.mobileReload=function(p){
        return this.each(function() {
            if (this.grid && this.p.url){
                this.grid.populate();
			}
        });
    };
    //更新页面配置
    $.fn.mobileOptions=function(p){
        return this.each(function() {
            if (this.grid)
                $.extend(this.p, p);
        });
    };
})(jQuery);